# DM Mobile Location - Quick Setup Guide

## 1. Install the Plugin

1. Upload `dm-mobile-location.zip` via **Plugins → Add New → Upload Plugin**
2. Click **Activate**

## 2. Get Your API Credentials

Go to **Mobile Location → Security** in WordPress admin:

- **API Endpoint**: `https://yoursite.com/wp-json/dm-mobile-location/v1/location`
- **API Key**: Copy the key shown (starts with `dm_`)

## 3. Add Map to Your Page

Add this shortcode to any page or post:

```
[dm_mobile_location]
```

## 4. Configure the iPhone App

1. Open the DM Mobile Location app
2. Enter the **API Endpoint** from step 2
3. Enter the **API Key** from step 2
4. Tap **Test Connection**
5. Tap **Save**

## 5. Update Your Location

1. Tap on the map or use GPS to set your location
2. Enter an optional label (e.g., "Lunch at City Park")
3. Tap **Update Location**

Your website map will now show your current location!

---

## Shortcode Options

| Option | Default | Description |
|--------|---------|-------------|
| `width` | 100% | Map width |
| `height` | 400px | Map height |
| `zoom` | 15 | Initial zoom level (1-18) |
| `show` | primary | `primary`, `all`, or location ID |
| `no_location_message` | Location coming soon! | Message when no location set |

Examples:
```
[dm_mobile_location height="500px" zoom="14"]
[dm_mobile_location show="all"]
[dm_mobile_location id="loc_abc123"]
```

---

## Customization

Go to **Mobile Location → Map Settings** to customize:

- Marker color and icon
- Map style (6 options)
- Popup colors
- Show/hide address, time, directions

---

## Troubleshooting

**"Invalid API key" in app**
- Verify the key matches exactly (no extra spaces)
- Try regenerating the key in **Security** settings

**Map not showing**
- Check the shortcode is correct: `[dm_mobile_location]`
- Verify at least one location has been set

**Location not updating**
- Clear your website cache
- Check "Location updated" message appears in app

---

## Support

- Plugin issues: Check WordPress admin for error messages
- App issues: See iPhone app README.md

© 2026 Dependent Media
